*-------------------------------------------------------------------------------
* Description: Prepare data from the 1968 National Vital Statistics.
* Author:      Brendan M. Price
*-------------------------------------------------------------------------------


* Load source data from the NBER website
unzipfile "https://data.nber.org/natality/1968/natl1968.dta.zip", replace
use "natl1968.dta", clear
rm "natl1968.dta"

* Retain select variables
keep mrace dmage metrores csex dlivord dbirwt dplural

* Recode mother's race
gen byte race = .
replace race = 1 if mrace == 1
replace race = 2 if mrace == 2
replace race = 3 if mrace >= 3
drop mrace

label define race_lbl 1 "White", replace
label define race_lbl 2 "Black", add
label define race_lbl 3 "Other", add
label values race race_lbl

* Mother's age
rename dmage age

* Metro residence
gen byte metro = (metrores == "1")
drop metrores

* Child sex
rename csex child_sex
label define child_sex_lbl 1 "Male", replace
label define child_sex_lbl 2 "Female", add
label values child_sex child_sex_lbl

* Birth order
gen byte birth_order = dlivord if dlivord != 99
drop dlivord

* Birth weight
gen int birth_weight = dbirwt if dbirwt != 9999
drop dbirwt

* Plural births
gen byte plural = (dplural > 1)
drop dplural

* Reorganize
order age race metro child_sex birth_order plural birth_weight

* Label variables
label variable age          "Mother's age"
label variable race         "Mother's race"
label variable metro        "Resides in metropolitan area"
label variable child_sex    "Child sex"
label variable birth_order  "Birth order (topcoded at 5)"
label variable plural       "Plural birth"
label variable birth_weight "Birth weight (grams)"

* Save to disk
compress
save "$basepath/data/vital.dta", replace
