*-------------------------------------------------------------------------------
* Description: Configure project settings and run all programs.
* Author:      Brendan M. Price
*-------------------------------------------------------------------------------


* Configure settings and install SSC packages
do "./profile.do" --install-ados


* Run programs in intended sequence
*-------------------------------------------------------------------------------

* Fetch and process source data
do "$basepath/code/build/build_states.do"
do "$basepath/code/build/build_eta.do"
do "$basepath/code/build/build_vital.do"

* Create figures
local flist : dir "$basepath/code/share" files "*.do"
local flist : list sort flist

foreach f of local flist {
	do "$basepath/code/share/`f'"
}

* Crop all output files
local flist : dir "$basepath/out" files "*.pdf"
local flist : list sort flist

foreach f of local flist {
	shell pdfcrop "$basepath/out/`f'" "$basepath/out/`f'"
}
