*-------------------------------------------------------------------------------
* Description: Set up project globals, adopaths, programs, and configurations.
* Author:      Brendan M. Price
*-------------------------------------------------------------------------------


* Initial configuration
*-------------------------------------------------------------------------------

* Specify Stata version on which code was developed and tested
version 15.1

* Reset programs and settings
discard
clear all

* Configure settings
set varabbrev off
set more off
set matsize 11000

* Set default execution behavior
local install_ados = 0

* Let user override default behavior via command-line arguments
while "`1'" != "" {
	if "`1'" == "--install-ados" {
		local install_ados = 1
	}
	else {
		display as error _n `"profile.do: "`1'" is an invalid command-line option"'
		exit = 9
	}

	macro shift
}


* Determine location of project folder
*-------------------------------------------------------------------------------

* Verify that this script is being run from within the "code" directory
assert substr("`c(pwd)'", -5, .) == "/code"

* Set the project directory
global basepath `=substr("`c(pwd)'", 1, length("`c(pwd)'") - 5)'
assert "$basepath" != ""


* Set up adopath and install/update .ado files
*-------------------------------------------------------------------------------

* Remove personal directories from the adopath
capture adopath - PERSONAL
capture adopath - PLUS
capture adopath - OLDPLACE

* Add custom commands and graphics files to the adopath
quietly adopath + "$basepath/lib"
quietly adopath + "$basepath/lib/ado"
quietly adopath + "$basepath/lib/schemes"

* Force Stata to search only the project directory for "personal" ado files
sysdir set PERSONAL "$basepath/lib"

* If requested: install SSC packages
if `install_ados' == 1 {
	* Store SSC packages within the project directory
	capture confirm file "$basepath/lib/ado"
	if _rc != 0 {
		mkdir "$basepath/lib/ado"
	}

	net set ado "$basepath/lib/ado"

	* Install SSC packages
	ssc install addplot, replace
	ssc install coefplot, replace
	ssc install freduse, replace
	ssc install ivreg2, replace
	ssc install labutil, replace
	ssc install ranktest, replace

	* Install non-SSC packages
	net install grc1leg, from(https://www.stata.com/users/vwiggins) replace
}


* Configure graphics
*-------------------------------------------------------------------------------

* Set graph appearance
set scheme spartan

* For console users: specify "graph export" options for LaTeX-style font
if "`c(console)'" != "" {
	global serif `"fontdir("$basepath/lib/fonts") fontface("CMU Serif")"'
}
else {
	global serif
}
