*-------------------------------------------------------------------------------
* Description: Plot the distribution of maternal age by birth order.
* Author:      Brendan M. Price
*
* 1. Transparent colors work best here given the overlapping distributions.
*-------------------------------------------------------------------------------


* Prepare the data
*-------------------------------------------------------------------------------

* Load natality counts
use "$basepath/data/vital.dta", clear

* Distinguish first vs. subsequent births
keep if !missing(birth_order)
replace birth_order = min(birth_order, 2)

* Bin extreme values of maternal age
replace age = 15 if age < 15
replace age = 45 if age > 45

* Count births by birth order and maternal age
gen births = 1
collapse (sum) births, by(birth_order age)

* Double birth counts because this is a 50 percent sample
replace births = 2 * births


* Create a histogram with overlapping regions
*-------------------------------------------------------------------------------

#delimit ;
twoway
	(bar births age if birth_order == 1, lcolor(black) lwidth(vvthin) color(%80))
	(bar births age if birth_order == 2, lcolor(black) lwidth(vvthin) color(%80)),
	xtitle("Mother's age")
	xscale(range(14 46))
	xlabel(15 "{&le}15" 20(5)40 45 "{&ge}45")
	ytitle("Number of births")
	ylabel(#8, format("%9.0fc"))
	plotregion(margin(b=0))
	xsize(8)
	ysize(4)
	scale(*1.3)
	legend(rows(2) ring(0) position(1) bmargin(t=5 r=10)
		label(1 "First child")
		label(2 "Second child or later"));
#delimit cr

* Export the figure
graph export "$basepath/out/birth_age.pdf", as(pdf) $serif replace
