*-------------------------------------------------------------------------------
* Description: Plot initial and continued UI claims.
* Author:      Brendan M. Price
*
* Notes:
* 1. As in a previous example, I use "grc1leg" to combine two panels with a
*    single shared legend. grc1leg failed to respect the options "xsize" and
*    "ysize", so I added a "graph display" command to get the right sizing.
* 2. I used a thin width for the n.s.a. series and a thick width for the s.a.
*    series so as to emphasize the latter.
*-------------------------------------------------------------------------------


* Prepare the data
*-------------------------------------------------------------------------------

* Load initial and continued claims
freduse ICNSA ICSA CCNSA CCSA, clear

rename ICNSA initclaims_n
rename ICSA initclaims
rename CCNSA contclaims_n
rename CCSA contclaims

* Express claims in millions
foreach v of varlist *claims* {
	replace `v' = `v'/1000000
}

* Focus on the Great Recession
keep if inrange(year(daten), 2005, 2013)

* Write year labels as of mid-year
local xlabels
local xticks

forvalues y = 2005/2014 {
	if mod(`y', 2) == 1 {
		local xlabels `"`xlabels' `=td(30jun`y')' "`y'""'
	}

	local xticks `xticks' `=td(30jun`y')'
}


* Left panel: initial claims; right panel: continued claims
*-------------------------------------------------------------------------------

foreach v in "initclaims" "contclaims" {
	if "`v'" == "initclaims" {
		local vlbl "Initial claims"
	}
	else if "`v'" == "contclaims" {
		local vlbl "Continued claims"
	}

	#delimit ;
	twoway
		(line `v'_n daten, yaxis(1 2) color(black) lwidth(vvthin))
		(line `v' daten, yaxis(1 2) color("scheme p1") lwidth(medthick)),
		title("{it:`vlbl'}")
		subtitle("Millions", position(1))
		xtitle("")
		xlabel(`xlabels')
		xticks(`xticks')
		ytitle("", axis(1))
		ytitle("", axis(2))
		yscale(range(0) axis(1))
		yscale(range(0) axis(2))
		ylabel(none, axis(1))
		ylabel(#8, axis(2) format(%5.1f))
		yticks(none, axis(1))
		plotregion(margin(b=0))
		legend(size(*0.8) bmargin(zero)
			label(1 "Not seasonally adjusted")
			label(2 "Seasonally adjusted"));
	#delimit cr

	tempfile g_`v'
	graph save "`g_`v''"
}

* Combine panels
grc1leg "`g_initclaims'" "`g_contclaims'", scale(*1.6)

* Export the figure
graph display, xsize(8)	ysize(4)
graph export "$basepath/out/ui_claims.pdf", as(pdf) $serif replace
