*-------------------------------------------------------------------------------
* Description: Plot the number unemployed by duration of unemployment.
* Author:      Brendan M. Price
*
* Notes:
* 1. Shadings of a single color often work best when the plotted series have a
*    natural ordering, as they do here.
* 2. Placing the "legend" labels inside each region aids readability but takes
*    some manual tinkering. A legend in the top left would also work well.
* 3. I use faint grey region borders to give each region a bit more definition.
*-------------------------------------------------------------------------------


* Prepare the data
*-------------------------------------------------------------------------------

* Load unemployment counts by duration unemployed
freduse UEMPLT5 UEMP5TO14 UEMP15T26 UEMP27OV, clear

* Extract date in year-month format
gen tm = ym(year(daten), month(daten))
format %tm tm

* Retain the years around the Great Recession
keep if inrange(tm, tm(2005m1), tm(2015m1))

* Cumulate unemployment by duration, in millions
gen u0 = 0
gen u1 = 1/1000 * (UEMPLT5)
gen u2 = 1/1000 * (UEMPLT5 + UEMP5TO14)
gen u3 = 1/1000 * (UEMPLT5 + UEMP5TO14 + UEMP15T26)
gen u4 = 1/1000 * (UEMPLT5 + UEMP5TO14 + UEMP15T26 + UEMP27OV)

* Kludge to thicken the topmost line (which is otherwise too thin)
gen u5 = u4 + .05

* Specify x-axis labels and ticks
local xticks
forvalues y = 2005/2015 {
	if `y' <= 2014 {
		local xlabels `"`xlabels' `=tm(`y'm7)' "`y'""'
	}

	local xticks `xticks' `=tm(`y'm1)'
}


* Plot unemployment rates
*-------------------------------------------------------------------------------

#delimit ;
twoway
	`shading'
	(rarea u1 u0 tm, yaxis(1 2) color(ebblue*0.1) lcolor(gs10) lwidth(vthin))
	(rarea u2 u1 tm, yaxis(1 2) color(ebblue*0.3) lcolor(gs10) lwidth(vthin))
	(rarea u3 u2 tm, yaxis(1 2) color(ebblue*0.5) lcolor(gs10) lwidth(vthin))
	(rarea u4 u3 tm, yaxis(1 2) color(ebblue*0.7) lcolor(gs10) lwidth(vthin))
	(rarea u5 u4 tm, yaxis(1 2) color(ebblue*0.9) lcolor(gs10) lwidth(vthin)),
	subtitle("Millions", position(1))
	xtitle("")
	xlabel(`xlabels', noticks)
	xticks(`xticks', tlength(medlarge))
	yscale(range(0 16.1) axis(1))
	yscale(range(0 16.1)axis(2))
	ylabel(0(2)16, axis(1))
	ylabel(0(2)16, axis(2))
	xsize(8)
	ysize(4)
	scale(*1.3)
	text(01.3 `=tm(2011m7)' "Less than 5 weeks", placement(e) justification(left))
	text(04.1 `=tm(2011m7)' "5-14 weeks", placement(e) justification(left))
	text(06.6 `=tm(2011m7)' "15-26 weeks", placement(e) justification(left))
	text(10.0 `=tm(2011m7)' "27 weeks or more", placement(e) justification(left))
	plotregion(margin(b=0))
	legend(off);
#delimit cr

* Export the figure
graph export "$basepath/out/unemp_duration.pdf", as(pdf) $serif replace
